function [f,g] = LL_mxl(~,XXa,~,~,err,EstimOpt,b0)

% save LL_mxl
% return

NAlt = EstimOpt.NAlt;
NCT = EstimOpt.NCT;
NP = EstimOpt.NP;
NRep = EstimOpt.NRep;
NVarA = EstimOpt.NVarA;
NVarS = EstimOpt.NVarS;
RealMin = EstimOpt.RealMin;


b0a = b0(1:NVarA);

b0v = (b0(NVarA+1:NVarA*2));

VC = diag(b0v);

b_mtx = reshape(b0a + VC*err,[NVarA,NRep,NP]);
p0 = zeros(NP,1);

g = zeros(NP, 2*NVarA + NVarS);
VC2 = reshape(err, NVarA, NRep, NP);

parfor n = 1:NP
    b_mtx_n = b_mtx(:,:,n);
    XXa_n = XXa(:,:,n);
    % With normalization
    %             U = reshape(XXa_n*b_mtx_n,NAlt-1,NCT,NRep);
    %             maxU = max(U);
    %             eU = exp(bsxfun(@minus, U, maxU));
    %             U_sum = reshape(exp(-maxU)+sum(eU,1),NCT,NRep);
    %             U_prod = prod(bsxfun(@rdivide, reshape(exp(-maxU), [NCT,NRep]), U_sum),1);
    %             p0(n) = mean(U_prod);
    %             U_prob = reshape(eU, (NAlt-1)*NCT,1,NRep);  % (NAlt-1)*NCT x 1 x NRep
    %             %p0(n) = max(mean(U_prod),realmin);
    
    % Without normalization
    U = reshape(exp(XXa_n*b_mtx_n),[NAlt-1,NCT,NRep]);  % NAlt -1 x NCT x NRep
    U_sum = reshape(1+sum(U,1),[NCT,NRep]);
    U_prod = prod(1./U_sum,1);
    p0(n) = mean(U_prod);
    U_prob = reshape(U,[(NAlt-1)*NCT,1,NRep]);  % (NAlt-1)*NCT x 1 x NRep
    
    % calculations for gradient
    
    %     X_hat = sum(reshape(bsxfun(@times,U_prob,XXa_n), NAlt-1, NCT, NVarA, NRep),1); % 1 x NCT x NVarA x NRep
    X_hat = sum(reshape(U_prob.*XXa_n, [NAlt-1, NCT, NVarA, NRep]),1); % 1 x NCT x NVarA x NRep
    %     F = -bsxfun(@rdivide,reshape(X_hat, [NCT,NVarA,NRep]), reshape(U_sum, [NCT,1,NRep]));
    F = -reshape(X_hat,[NCT,NVarA,NRep])./reshape(U_sum,[NCT,1,NRep]);
    sumFsqueezed = reshape(sum(F,1),[NVarA,NRep]);  %NVarA x NRep
    %     sumVC2tmp = bsxfun(@times, sumFsqueezed, VC2(:,:,n));
    sumVC2tmp = sumFsqueezed.*VC2(:,:,n);
    %     gtmp = -mean([bsxfun(@times, sumFsqueezed, U_prod); bsxfun(@times, sumVC2tmp, U_prod)],2)./p0(n);
    gtmp = -mean([sumFsqueezed.*U_prod; sumVC2tmp.*U_prod],2)./p0(n);
    g(n,:) = gtmp';
    
end
% f = -log(p0);

if RealMin == 1
    g(isnan(g)) = 0;
    f = -log(max(p0,realmin));
else
    f = -log(p0);
end
